/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.expression.aggregate;

import java.sql.Connection;
import java.sql.SQLException;
import org.h14199.api.Aggregate;
import org.h14199.command.Parser;
import org.h14199.command.dml.Select;
import org.h14199.engine.Session;
import org.h14199.engine.UserAggregate;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionVisitor;
import org.h14199.expression.aggregate.AbstractAggregate;
import org.h14199.expression.aggregate.AggregateDataCollecting;
import org.h14199.message.DbException;
import org.h14199.value.DataType;
import org.h14199.value.TypeInfo;
import org.h14199.value.Value;
import org.h14199.value.ValueBoolean;
import org.h14199.value.ValueNull;
import org.h14199.value.ValueRow;

public class JavaAggregate
extends AbstractAggregate {
    private final UserAggregate userAggregate;
    private int[] argTypes;
    private int dataType;
    private Connection userConnection;

    public JavaAggregate(UserAggregate userAggregate, Expression[] expressionArray, Select select, boolean bl) {
        super(select, expressionArray, bl);
        this.userAggregate = userAggregate;
    }

    @Override
    public int getCost() {
        int n = 5;
        for (Expression expression : this.args) {
            n += expression.getCost();
        }
        if (this.filterCondition != null) {
            n += this.filterCondition.getCost();
        }
        return n;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        Parser.quoteIdentifier(stringBuilder, this.userAggregate.getName(), bl).append('(');
        JavaAggregate.writeExpressions(stringBuilder, this.args, bl);
        stringBuilder.append(')');
        return this.appendTailConditions(stringBuilder, bl);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!super.isEverything(expressionVisitor)) {
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 1: 
            case 2: {
                return false;
            }
            case 7: {
                expressionVisitor.addDependency(this.userAggregate);
                break;
            }
        }
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return this.filterCondition == null || this.filterCondition.isEverything(expressionVisitor);
    }

    @Override
    public Expression optimize(Session session) {
        super.optimize(session);
        this.userConnection = session.createConnection(false);
        int n = this.args.length;
        this.argTypes = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            this.argTypes[i] = n2 = this.args[i].getType().getValueType();
        }
        try {
            Aggregate aggregate = this.getInstance();
            this.dataType = aggregate.getInternalType(this.argTypes);
            this.type = TypeInfo.getTypeInfo(this.dataType);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        return this;
    }

    private Aggregate getInstance() {
        Aggregate aggregate = this.userAggregate.getInstance();
        try {
            aggregate.init(this.userConnection);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        return aggregate;
    }

    @Override
    public Value getAggregatedValue(Session session, Object object) {
        try {
            Object object2;
            Aggregate aggregate;
            if (this.distinct) {
                aggregate = this.getInstance();
                object2 = (AggregateDataCollecting)object;
                if (object2 != null) {
                    for (Value value : ((AggregateDataCollecting)object2).values) {
                        if (this.args.length == 1) {
                            aggregate.add(value.getObject());
                            continue;
                        }
                        Value[] valueArray = ((ValueRow)value).getList();
                        Object[] objectArray = new Object[this.args.length];
                        int n = this.args.length;
                        for (int i = 0; i < n; ++i) {
                            objectArray[i] = valueArray[i].getObject();
                        }
                        aggregate.add(objectArray);
                    }
                }
            } else {
                aggregate = (Aggregate)object;
                if (aggregate == null) {
                    aggregate = this.getInstance();
                }
            }
            if ((object2 = aggregate.getResult()) == null) {
                return ValueNull.INSTANCE;
            }
            return DataType.convertToValue(session, object2, this.dataType);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    protected void updateAggregate(Session session, Object object) {
        this.updateData(session, object, null);
    }

    private void updateData(Session session, Object object, Value[] valueArray) {
        try {
            if (this.distinct) {
                AggregateDataCollecting aggregateDataCollecting = (AggregateDataCollecting)object;
                Value[] valueArray2 = new Value[this.args.length];
                Value value = null;
                int n = this.args.length;
                for (int i = 0; i < n; ++i) {
                    value = valueArray == null ? this.args[i].getValue(session) : valueArray[i];
                    valueArray2[i] = value = value.convertTo(this.argTypes[i]);
                }
                aggregateDataCollecting.add(session.getDatabase(), this.args.length == 1 ? value : ValueRow.get(valueArray2));
            } else {
                Aggregate aggregate = (Aggregate)object;
                Object[] objectArray = new Object[this.args.length];
                Object object2 = null;
                int n = this.args.length;
                for (int i = 0; i < n; ++i) {
                    Value value = valueArray == null ? this.args[i].getValue(session) : valueArray[i];
                    value = value.convertTo(this.argTypes[i]);
                    objectArray[i] = object2 = value.getObject();
                }
                aggregate.add(this.args.length == 1 ? object2 : objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    protected void updateGroupAggregates(Session session, int n) {
        super.updateGroupAggregates(session, n);
        for (Expression expression : this.args) {
            expression.updateAggregate(session, n);
        }
    }

    @Override
    protected int getNumExpressions() {
        int n = this.args.length;
        if (this.filterCondition != null) {
            ++n;
        }
        return n;
    }

    @Override
    protected void rememberExpressions(Session session, Value[] valueArray) {
        int n = this.args.length;
        for (int i = 0; i < n; ++i) {
            valueArray[i] = this.args[i].getValue(session);
        }
        if (this.filterCondition != null) {
            valueArray[n] = ValueBoolean.get(this.filterCondition.getBooleanValue(session));
        }
    }

    @Override
    protected void updateFromExpressions(Session session, Object object, Value[] valueArray) {
        if (this.filterCondition == null || valueArray[this.getNumExpressions() - 1].getBoolean()) {
            this.updateData(session, object, valueArray);
        }
    }

    @Override
    protected Object createAggregateData() {
        return this.distinct ? new AggregateDataCollecting(true) : this.getInstance();
    }
}

